/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.nbt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public final class NBTProcessors {
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> processors = new HashMap();
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> survivalProcessors = new HashMap();
    private static final UnaryOperator<class_2487> signProcessor = data -> {
        for (String key : List.of("front_text", "back_text")) {
            class_2487 textTag = data.method_10562(key);
            if (!textTag.method_10573("messages", 9)) continue;
            for (class_2520 tag : textTag.method_10554("messages", 8)) {
                class_2519 stringTag;
                if (!(tag instanceof class_2519) || !NBTProcessors.textComponentHasClickEvent((stringTag = (class_2519)tag).method_10714())) continue;
                return null;
            }
        }
        if (data.method_10545("front_item") || data.method_10545("back_item")) {
            return null;
        }
        return data;
    };

    public static synchronized void addProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<class_2487> itemProcessor(String tagKey) {
        return data -> {
            class_2487 compound = data.method_10562(tagKey);
            if (!compound.method_10573("tag", 10)) {
                return data;
            }
            class_2487 itemTag = compound.method_10562("tag");
            HashSet keys = new HashSet(itemTag.method_10541());
            for (String key : keys) {
                if (!NBTProcessors.isUnsafeItemNBTKey(key)) continue;
                itemTag.method_10551(key);
            }
            if (itemTag.method_33133()) {
                compound.method_10551("tag");
            }
            return data;
        };
    }

    public static class_1799 withUnsafeNBTDiscarded(class_1799 stack) {
        if (stack.method_7969() == null) {
            return stack;
        }
        class_1799 copy = stack.method_7972();
        for (String key : stack.method_7969().method_10541()) {
            if (!NBTProcessors.isUnsafeItemNBTKey(key)) continue;
            copy.method_7983(key);
        }
        return copy;
    }

    public static boolean isUnsafeItemNBTKey(String name) {
        if (name.equals("StoredEnchantments")) {
            return false;
        }
        if (name.equals("Enchantments")) {
            return false;
        }
        if (name.contains("Potion")) {
            return false;
        }
        if (name.contains("Damage")) {
            return false;
        }
        return !name.equals("display");
    }

    public static boolean textComponentHasClickEvent(String json) {
        return NBTProcessors.textComponentHasClickEvent((class_2561)class_2561.class_2562.method_10877((String)(json.isEmpty() ? "\"\"" : json)));
    }

    public static boolean textComponentHasClickEvent(class_2561 component) {
        for (class_2561 sibling : component.method_10855()) {
            if (!NBTProcessors.textComponentHasClickEvent(sibling)) continue;
            return true;
        }
        return component != null && component.method_10866() != null && component.method_10866().method_10970() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static class_2487 process(class_2680 state, class_2586 blockEntity, @Nullable class_2487 compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        class_2591 type = blockEntity.method_11017();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (class_2487)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (class_2487)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof class_2636) {
            return compound;
        }
        if (state.method_26164(class_3481.field_41282)) {
            return (class_2487)signProcessor.apply(compound);
        }
        if (blockEntity.method_11011()) {
            return null;
        }
        return compound;
    }
}

